#ifndef CLS_NETADMIN_INTERFACE_H
#define CLS_NETADMIN_INTERFACE_H

#include "CommonFun.h"

//Product Model
#define TC_NVSS					0x0000
#define TC_NS621S				0x0010			
#define TC_NS621S_USB			0x0011			
#define TC_NS224S				0x0020			
#define TC_NC621S				0x0030			
#define TC_NC8000S				0x0040			
#define TC_NC8001S				0x0041			
#define TC_NC8100S				0x0042			
#define TC_NC8101S				0x0043			
#define TC_NC8200S				0x0044			
#define TC_NC8700S2				0x0045
#define	TC_NC9100S1_MP_IR       0x0046	
#define TC_NC8250				0x0050			
#define TC_NC9010S2_MP			0x0051			
#define TC_NC9000S2_2MP			0x0052			
#define TC_NC9010N1_2MP			0x0053			
#define TC_NC9000S3_3MP			0x0054			
#define TC_NH9106N1_2MPIR		0x0055			
#define	TC_NS921_N1_2MP			0x0056	
#define	TC_NS921S3_HD_V1        0x0056			
#define TC_CC9118_MP_E			0x0057			
#define TC_NH9206N1_MPIR_IVS	0x0058			
#define TC_NC9100S3_3MP_IR30    0x0059          
#define TC_NT9054S2_MPIR		0x005A	
#define	TC_NC9000S3_2MP_E       0x005B			
#define	TC_NC9200S3_MP_E_IR15   0x005C
#define TC_NH9206S3_2MP_IVS		0x005D	
#define	TC_NC9000S3_MP_E        0x005E
#define TC_NS621S2				0x0060			
#define TC_NS622S2				0x0061			
#define TC_NS324S2				0x0062			
#define TC_NS628S2 				0x0064	
#define	TC_FS0013ERS_HD         0x0070
#define TC_NC9100S3E_MP_IR30	0x0080
#define TC_NC9000S3E_MP			0x0081
#define TC_NC9200S3E_MP_IR		0x0082
#define TC_NC9100S3E_2MP_IR30	0x0083
#define TC_NC9000S3E_2MP		0x0084
#define TC_NC9200S3E_2MP_IR		0x0085
#define TC_NC921S3E_MP_HD_C		0x0086
#define TC_NH9406S3E_MPIR       0x0087
#define TC_NH9406S3E_2MPIR		0x0088
#define TC_NC9320S3E_2MP_E		0x0089
#define TC_NC9400S3E_MP_C_IR30	0x008A
#define TC_NC9200S3E_2MP_E_I3	0x008B
#define TC_NC9320S3E_MP_E		0x0090
#define TC_NC9000S3E_5MP_UE		0x0091
#define	TC_NC9001S3E_3MP_E		0x0092	
#define	TC_NC9201S3E_3MP_EI_IR	0x0093
#define	TC_NH9806S6_3MPIR_I		0x0094
#define	TC_CC9033_3MP			0x0095
#define TC_NC9401S3E_4MP_I5_E	0x0096
#define TC_NC9401S3E_4MP_I_E	0x0097
#define TC_NC9001S3E_2MP_ES		0x0098
#define TC_NH9904S6_2MP			0x0099
#define TC_NH9806S6_2MPIR_S_A	0x009A
#define TC_NC9320S3E_2MP_D		0x009B

#define TC_NC9010I_2MP			0x00A1			
#define TC_NC9000I_5MP			0x00A2			
#define TC_21X_R2				0x00A3			
#define TC_21X_R3				0x00A4			
#define TC_21X_R5				0x00A5
#define TC_217_T2				0x00A6
#define TC_217_T3				0x00A7
#define TC_218_T5	            0x00A8
#define	TC_218_T3H				0x00A9	
#define	TC_217_T5				0x00AA	
#define	TC_217_T3H				0x00AB
#define	TC_237_5MPH				0x00AC
#define	TC_238_5MPH				0x00AD
#define	TC_227_2MP_S_Z			0x00AE
#define	TC_217_1MP_S			0x00AF
#define TC_NH9X06S6_XMPIR_A		0x00D0
#define TC_NH9X06S6_XMPIR_T		0x00D1
#define TC_T237_2MP_S			0x00E0
#define TC_NC9201S3E_4MP_EI_IR30    0x00E1
#define TC_NC9201S3E_4MP_EI_IR30_M  0x00E2
#define TC_NC9101S3E_2MP_EI_IRW30_S 0x00E3
#define TC_NC9201S3E_2MP_EI_IR30    0x00E4
#define TC_NC9011S3E_3MP		0x00E5
#define TC_NC9501S3E_2MP_I3S	0x00E6
#define TC_NC9201S3E_2MP_I3S	0x00E7
#define TC_NH9806S6_2MPIR_S_T	0x00E8
#define TC_NC9304S3E_2MP_S		0x00E9
//end

#define TC_2816AN_SH			0x0100			
#define TC_2808AN_S_3511		0x0110			
#define TC_2816AN_SD			0x0120			
#define TC_2816AN_SD_E          0x0121			
#define TC_2808AN_S_3515		0x0130			
#define TC_2804AN_MX			0x0131			
#define TC_2816AN_S				0x0140			
#define TC_H802BHX_T			0x0141			
#define TC_2832AN_SS            0x0142			
#define TC_H804BE_HD            0x0143			
#define TC_1002S2_3C			0x0150			
#define TC_H804N_HD				0x0151			
#define	TC_2802AN_SDI			0x0160			
#define TC_H908NC_H_V50			0x0161			
#define TC_2800AN_SF_L_H		0x0170			
#define TC_2800AN_SF_H			0x0171			
#define TC_2804AN_SA			0x0172			
#define TC_2800AN_SF_L			0x0173			
#define TC_2800AN_SF			0x0174			
#define TC_H804BE_P				0x0175	
#define TC_2808AN_SF_L			0x0176
#define	TC_2804AN_SQ        	0x0177
#define TC_T800GE				0x0188

#define TC_2804AN_SR_L			0x0178
#define TC_H804I_HD_BP			0x0179
#define TC_H904B_HD_V6_X		0x017A
#define TC_H908NC_HD			0x017B

#define TC_2800AN_R16_S2		0x017C
#define	TC_2804AN_M				0x017D
#define TC_2800AN_R4_S1			0x017E
#define TC_2800AN_R4_S2			0x017F
#define TC_2800AN_R8_S2			0x017F

#define TC_H804N_HD_P			0x0180
#define TC_2800AN_R16_S2_V2_0   0x0181
#define TC_2800AN_R16_S4	    0x0181
#define TC_2800AN_R32_S4        0x0181

#define TC_2816AN_SR_V2_0		0x0182
#define TC_2832AN_SR_V2_0		0x0182

#define TC_2800AN_R4_S1_V2_0	0x0183

#define TC_ND921S2_MP			0x0400			
#define	TC_ND921S2_2MP			0x0410			
#define	TC_ND921S2_SDI			0x0411	
#define TC_ND922S4_C			0x0412
#define TC_ND921S5				0x0420
#define TC_NX212_C				0x0421
#define	TC_2804AN_SDI			0x0500	
#define	TC_2864AN_SR			0x0520
#define TC_7816W				0x0600
#define TC_H904BIX_HD_I			0x0184

#define TC_T238_5MP_S_Z			0x00B0
#define TC_T238_6MP				0x00B2
#define TC_T237_6MP				0x00B3
#define TC_T238_6MP_B			0x00B4
#define TC_T237_7MP				0x00B5
#define TC_T238_7MP				0x00B6
//
#define TC_NR2160M7_E16			0x0190
#define TC_NR2080M7_E16			0x0190
#define TC_NR2080M7_E8			0x0190
#define TC_NR2040M7_E8			0x0190
#define TC_NR2020M7_E8			0x0190
#define TC_NR2080M7_S8			0x0190
#define TC_NR2040M7_S8			0x0190
#define TC_NR2020M7_S8			0x0190
#define TC_NR2040M7_S4			0x0191
#define TC_NR2020M7_S4			0x0191	
#define TC_NR2020M7_S2			0x0192

#define TC_T237_2MP_S			0x00E0

#define TC_NH9406S6_MPIR_S		0x009E
#define TC_NH9606S6_2MPIR_S		0x009F
#define	TC_T1					0x009C	
#define	TC_NC9101S3E_2MP_ES		0x009D	
#define	T227_2MP_S_Z_V2			0x00B7	
#define	TC_H804N_HD_4SATA		0x0118	
#define	TC_2800AN_P4_S1			0x0185	
#define	TC_2800AN_P4_S2			0x0186	
#define	TC_2800AN_P16_S4		0x0187	
#define	TC_2816AN_SR_DZ15543	0x0189	
#define	TC_NR2020M7_S1			0x01A0	
#define	TC_NR2010M7_S1			0x01A1	
#define	TC_H802_XK				0x0510	
#define TC_H904BIX_N			0x0530	


#define TYPE_NVS_T          0     //T NVS
#define TYPE_KEYBOARD       1     //Net keyboard
#define TYPE_CTL_ALLOTER    2     //Control code distributor
#define TYPE_ALARMHOST      3     //Network alarm host
#define TYPE_NVS_S          4     //S NVS
#define TYPE_MATRIX         5     //Matrix
#define TYPE_NET_PU         6     //Network Front-end device
#define TYPE_NET_GURAD      7     //Net Entrance Gurad
#define TYPE_PC_DVR         8     //PC DVR
#define TYPE_S_DECODER      9     //S Decoder
#define TYPE_NVS_TPLUS      10    //TPLUS NVS
#define TYPE_WIH_S          11    //ְ
#define TYPE_EMBED_DVR      12    //ǶʽDVR

typedef struct
{
	char    m_cIP[16];
	char    m_cMAC[18];
	char    m_cMask[16];
	char    m_Gateway[16];
	char    m_cDNS[16];
	int     m_iChanNum;
	int     m_iServerPort;
	int     m_iClientPort;
	int     m_iDeviceType;
	int     m_iHttpPort;
	int     m_iProductModel;
	char    m_cFactoryID[64];
	char    m_cKernelVersion[64];
	char    m_cOCXVersion[64];
}TDEVICE, *PTDEVICE;

typedef void (__stdcall *FIND_NOTIFY)(PTDEVICE _pDevice);

TYPEDEF_FUNCTION(NetAdmin_Startup)();
TYPEDEF_FUNCTION(NetAdmin_Closeup)();
TYPEDEF_FUNCTION(NetAdmin_SetNotify)(FIND_NOTIFY _Notify);
TYPEDEF_FUNCTION(NetAdmin_SeekServers)();
TYPEDEF_FUNCTION(NetAdmin_ChangeIP)(char* _strMAC, char* _newIP, char* _cMask, char* _Gateway, char* _cDNS);
TYPEDEF_FUNCTION(NetAdmin_ChangeMAC)(char* _strMac, char* _strNew);
TYPEDEF_FUNCTION(NetAdmin_ChangePort)(char* _strMAC, int _serverPort, int _clientPort);
TYPEDEF_FUNCTION(NetAdmin_RebootServer)(char* _strMac);
TYPEDEF_FUNCTION(NetAdmin_SetNetInterface)(int _iInterface);
TYPEDEF_FUNCTION_RET(char*,NetAdmin_GetNetInterface)(int _iIndex);

DECLARE_FUNCTION(NetAdmin_Startup);
DECLARE_FUNCTION(NetAdmin_Closeup);
DECLARE_FUNCTION(NetAdmin_SetNotify);
DECLARE_FUNCTION(NetAdmin_SeekServers);
DECLARE_FUNCTION(NetAdmin_ChangeIP);
DECLARE_FUNCTION(NetAdmin_RebootServer);
DECLARE_FUNCTION(NetAdmin_ChangeMAC);
DECLARE_FUNCTION(NetAdmin_ChangePort);
DECLARE_FUNCTION(NetAdmin_SetNetInterface);
DECLARE_FUNCTION(NetAdmin_GetNetInterface);

class CLS_NetAdmin_Interface
{
public :
    static bool LoadDLL();
    static void FreeDLL();

private:
	static HINSTANCE s_hInstance;
	static CString s_strFilePath;
};

#endif
